%{ 
    Function: plotThemAll
    -Plots all the elements of given deployment.

    Input:
    - set: Deployment set structure
    - data: Deployment data
    - bcCoords: Beacons coordinates
    - level: Floor that is being plotted

    Output:
    - It generates a figure plot

    Copyright  2020 University of Extremadura (UEx)    
 %}

function plotSingleFloor(set,data,level)

   colorH1 = 'b';
   colorH2 = 'g';
   colorH3 = 'r';
    
    if ((set.id == 1) || (set.id == 2))
        
        % Pysics environtment information
        utils_Physics_Part0;
        utils_Physics_Part1;
        utils_Physics_Part2;
        utils_Physics_Part3;

        load("dataPhysics.mat");
        fig1=figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','off');hold on;
       
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,level);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        hold on
        plot3(dataPhysics.pE1(:,1),dataPhysics.pE1(:,2),dataPhysics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
        % Sample points plot
        coord = separeteCoordinatesforFloor(set,dataPhysics,data.coords,level);
        aa = plot3(coord(:,1),coord(:,2),coord(:,3),'x','Color',colorH1,'MarkerSize',5);
        hold on
        
         % Beacons coordinate Plot
        coord = separeteCoordinatesforFloor(set,dataPhysics,data.bcCoords,level);
        bb = plot3(coord(:,1),coord(:,2),coord(:,3),'*','Color',colorH2,'MarkerSize',8);
        hold on
        
        
        % Leyenda
        xlim([-5 70])
        ylim([-5 30])
        pbaspect([1 1 1])
        xticks([-5:5:70])
        yticks([-5:5:30])
        legend([aa,bb],'Sample points','Beacons positions','FontSize',30,'FontName', 'Times New Roman','Position',[0.67 0.65 0.2 0.2]);
        hold off
        
        % Labels and title
        xlabel("West - East (m)",'FontSize',20,'FontName', 'Times New Roman');
        ylabel("South - North (m)",'FontSize',20,'FontName', 'Times New Roman');
        zlabel("Height (m)",'FontSize',20,'FontName', 'Times New Roman');
        % title(strcat("Physics department building - Floor:", num2str(level)," Deployment: ",num2str(set.id)));
        
        %old_sdf(fig1,'2019_Sensors')
        daspect([1 1 1])
        fig1.Renderer = 'Painters'
        print(fig1,strcat("figures/Physics_departament_floor",num2str(level),".pdf"),'-dpdf');
        
        
    elseif  (set.id == 3)
        
        utils_Physics_Part0;
        utils_Physics_Part1;
        utils_Physics_Part2;
        utils_Physics_Part3; 
        utils_Physics_Part4;
        
        utils_Mathematics_Part0;
        utils_Mathematics_Part1;
        utils_Mathematics_Part2;
        utils_Mathematics_Part3;
        utils_Mathematics_Part4;
        
        load("dataPhysics.mat");
        load("dataMathematics.mat");
        fig1=figure('PaperUnits','centimeters','PaperSize',[40,30],'PaperPosition',[0 0 40 30],'visible','on');hold on;
       
       
        % Mathematics environtment plot
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,level);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % FIX ME
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataMathematics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        plot3(dataMathematics.pE1(:,1),dataMathematics.pE1(:,2),dataMathematics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
        
        % Pysics environtment plot
        % Floor 0
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,0);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        
        % Floor 3
        [X1,X2,Y1,Y2,Z1,Z2] = dataForPlot(dataPhysics,3);
        plot3([X1; X2], [Y1; Y2], [Z1; Z2],'Color',[0.65 0.65 0.65] ,'MarkerSize',10);
        hold on
        
        plot3(dataPhysics.pE1(:,1),dataPhysics.pE1(:,2),dataPhysics.pE1(:,3),'Color','K','MarkerSize',10);
        hold on
       
        % Sample points plot
        coord = separeteCoordinatesforFloor(set,dataPhysics,data.coords,level);
        aa = plot3(coord(:,1),coord(:,2),coord(:,3),'x','Color',colorH1,'MarkerSize',5);
        hold on
        
        % Beacons coordinate Plot
        coord = separeteCoordinatesforFloor(set,dataPhysics,data.bcCoords,level);
        bb = plot3(coord(:,1),coord(:,2),coord(:,3),'*','Color',colorH2,'MarkerSize',8);
        hold on

        legend([aa,bb],'Sample points','Beacons positions','FontSize',30,'FontName', 'Times New Roman','Position',[0.67 0.85 0.2 0.2]);
        xlim([-10 90])
        ylim([-10 100])
        hold off 
        xticks([-10:10:90]);
        yticks([-10:10:100]);     
        
        % Labels and title
        xlabel("West - East (m)",'FontSize',20,'FontName', 'Times New Roman');
        ylabel("South - North (m)",'FontSize',20,'FontName', 'Times New Roman');
        zlabel("Height (m)",'FontSize',20,'FontName', 'Times New Roman');
        % title(strcat("Physics department building - Floor:", num2str(level)," Deployment: ",num2str(set.id)));
        
        hold off
        %old_sdf(fig1,'2019_Sensors')
        daspect([1 1 1])
        fig1.Renderer = 'Painters'
        print(fig1,strcat("figures/Physics_and_mathematics_departament_floor",num2str(level),".pdf"),'-dpdf');
        
        
    end
end